/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.stream.Stream;
import org.jdbi.v3.sqlobject.AbstractSqlObjectFactory;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectAnnotationHelper;

public final class SqlObjectFactory
extends AbstractSqlObjectFactory {
    public static final String EXTENSION_ID = "SQL_OBJECT";

    SqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        if (!extensionType.isInterface()) {
            return false;
        }
        if (SqlObjectFactory.isConcrete(extensionType)) {
            return false;
        }
        if (SqlObject.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(SqlObjectAnnotationHelper::matchSqlAnnotations);
    }
}

