/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionConfigurer;
import org.jdbi.v3.sqlobject.config.RegisterCollectorFactory;

public class RegisterCollectorFactoryImpl
implements ExtensionConfigurer {
    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        this.configureForType(registry, annotation, sqlObjectType);
    }

    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        RegisterCollectorFactory registerCollectorFactory = (RegisterCollectorFactory)annotation;
        JdbiCollectors collectors = (JdbiCollectors)registry.get(JdbiCollectors.class);
        Class<? extends CollectorFactory> type = registerCollectorFactory.value();
        try {
            collectors.register(type.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException("Unable to instantiate collector factory class " + registerCollectorFactory.value(), e);
        }
    }
}

