/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.AbstractSqlObjectFactory;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectAnnotationHelper;

public final class SqlObjectFactory
extends AbstractSqlObjectFactory {
    public static final String EXTENSION_ID = "SQL_OBJECT";

    SqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        if (!extensionType.isInterface()) {
            return false;
        }
        if (SqlObjectFactory.isConcrete(extensionType)) {
            return false;
        }
        if (SqlObject.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(SqlObjectAnnotationHelper::matchSqlAnnotations);
    }

    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return EnumSet.of(ExtensionFactory.FactoryFlag.VIRTUAL_FACTORY);
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        throw new UnsupportedOperationException();
    }
}

