/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlCallHandler
extends CustomizingStatementHandler<Call> {
    private final BiFunction<OutParameters, Call, ?> returner;

    public SqlCallHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.returner = this.createReturner(sqlObjectType, method);
    }

    private BiFunction<OutParameters, Call, ?> createReturner(Class<?> sqlObjectType, Method method) {
        Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
        Class returnClass = GenericTypes.getErasedType((Type)returnType);
        for (int idx = 0; idx < method.getParameterCount(); ++idx) {
            int pIdx = idx;
            Parameter p2 = method.getParameters()[idx];
            if (p2.getType().equals(Function.class)) {
                return (op, c) -> ((Function)((SqlObjectStatementConfiguration)c.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[pIdx]).apply(op);
            }
            if (!p2.getType().equals(Consumer.class)) continue;
            return (op, c) -> {
                ((Consumer)((SqlObjectStatementConfiguration)c.getConfig(SqlObjectStatementConfiguration.class)).getArgs()[pIdx]).accept(op);
                return null;
            };
        }
        if (Void.TYPE.equals(returnClass)) {
            return (p, c) -> null;
        }
        if (OutParameters.class.isAssignableFrom(returnClass)) {
            return (p, c) -> p;
        }
        throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
    }

    @Override
    Call createStatement(Handle handle, String locatedSql) {
        return handle.createCall(locatedSql);
    }

    @Override
    void configureReturner(Call c, SqlObjectStatementConfiguration cfg) {
        cfg.setReturner(() -> this.returner.apply(c.invoke(), c));
    }
}

