/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;

class BridgeMethodHandlerFactory
implements HandlerFactory {
    BridgeMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        if (!method.isBridge()) {
            return Optional.empty();
        }
        return Stream.of(sqlObjectType.getMethods()).filter(candidate -> !candidate.isBridge() && Objects.equals(candidate.getName(), method.getName()) && candidate.getParameterCount() == method.getParameterCount()).filter(candidate -> {
            Class[] candidateParamTypes = candidate.getParameterTypes();
            Class[] methodParamTypes = method.getParameterTypes();
            return IntStream.range(0, method.getParameterCount()).allMatch(i -> methodParamTypes[i].isAssignableFrom(candidateParamTypes[i]));
        }).map(m -> (target, args, handle) -> m.invoke(target, args)).findFirst();
    }
}

