/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.UseSqlParser;

public class UseSqlParserImpl
implements Configurer {
    @Override
    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        UseSqlParser anno = (UseSqlParser)annotation;
        try {
            SqlParser parser = this.instantiate(anno.value(), sqlObjectType, method);
            ((SqlStatements)registry.get(SqlStatements.class)).setSqlParser(parser);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        UseSqlParser anno = (UseSqlParser)annotation;
        try {
            SqlParser parser = this.instantiate(anno.value(), sqlObjectType, null);
            ((SqlStatements)registry.get(SqlStatements.class)).setSqlParser(parser);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private SqlParser instantiate(Class<? extends SqlParser> value, Class<?> sqlObjectType, Method m) throws Exception {
        try {
            Constructor<? extends SqlParser> no_arg = value.getConstructor(new Class[0]);
            return no_arg.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends SqlParser> class_arg = value.getConstructor(Class.class);
                return class_arg.newInstance(sqlObjectType);
            }
            catch (NoSuchMethodException e1) {
                if (m != null) {
                    Constructor<? extends SqlParser> c_m_arg = value.getConstructor(Class.class, Method.class);
                    return c_m_arg.newInstance(sqlObjectType, m);
                }
                throw new IllegalStateException("Unable to instantiate, no viable constructor " + value.getName());
            }
        }
    }
}

