/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface DefineList {
    public String value() default "";

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
            DefineList d = (DefineList)annotation;
            String name = ParameterUtil.getParameterName(d, d.value(), param);
            return (stmt, arg) -> {
                List<Object> argsList;
                if (arg instanceof List) {
                    argsList = (List<Object>)arg;
                } else if (arg instanceof Object[]) {
                    argsList = Arrays.asList((Object[])arg);
                } else {
                    if (arg == null) {
                        throw new IllegalArgumentException("A null object was passed as a @DefineList parameter. @DefineList is only supported on List and array arguments");
                    }
                    throw new IllegalArgumentException("A " + arg.getClass() + " object was passed as a @DefineList parameter. @DefineList is only supported on List and array arguments");
                }
                if (argsList.isEmpty()) {
                    throw new IllegalArgumentException("An empty list was passed as a @DefineList parameter. Can't define an empty attribute.");
                }
                if (argsList.contains(null)) {
                    throw new IllegalArgumentException("A @DefineList parameter was passed a list with null values in it.");
                }
                stmt.defineList(name, argsList);
            };
        }
    }
}

