/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlObjectStatementConfiguration;

abstract class CustomizingStatementHandler<StatementType extends SqlStatement<StatementType>>
implements Handler {
    private final List<FactoryAnnotationPair> typeBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationPair> methodBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationParameterIndex> paramBasedCustomizerFactories = new ArrayList<FactoryAnnotationParameterIndex>();
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> sqlObjectType, Method method) {
        this.sqlObjectType = sqlObjectType;
        this.method = method;
        for (Annotation annotation : sqlObjectType.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            if (!annotation.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation a = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = a.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create sql statement customizer factory", e);
            }
            this.typeBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        for (Annotation annotation : method.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation scf = annotationType.getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = scf.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate statement customizer factory", e);
            }
            this.methodBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Parameter[] parameters = method.getParameters();
        for (int paramIndex = 0; paramIndex < paramAnnotations.length; ++paramIndex) {
            boolean foundCustomizingAnnotations = false;
            for (Annotation annotation : paramAnnotations[paramIndex]) {
                SqlStatementCustomizerFactory f;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
                SqlStatementCustomizingAnnotation sca = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
                try {
                    f = sca.value().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate sql statement customizer factory", e);
                }
                this.paramBasedCustomizerFactories.add(new FactoryAnnotationParameterIndex(f, annotation, parameters[paramIndex], paramIndex));
                foundCustomizingAnnotations = true;
            }
            if (foundCustomizingAnnotations) continue;
            this.paramBasedCustomizerFactories.add(new FactoryAnnotationParameterIndex(new Bind.Factory(), null, parameters[paramIndex], paramIndex));
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier hs) throws Exception {
        Handle h = hs.getHandle();
        String locatedSql = this.locateSql(h);
        StatementType stmt = this.createStatement(h, locatedSql);
        SqlObjectStatementConfiguration cfg = (SqlObjectStatementConfiguration)stmt.getConfig(SqlObjectStatementConfiguration.class);
        this.configureReturner(stmt, cfg);
        this.applyCustomizers((SqlStatement<?>)stmt, args);
        return cfg.getReturner().get();
    }

    abstract void configureReturner(StatementType var1, SqlObjectStatementConfiguration var2);

    abstract StatementType createStatement(Handle var1, String var2);

    String locateSql(Handle h) {
        return ((SqlObjects)h.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.method);
    }

    void applyCustomizers(SqlStatement<?> stmt, Object[] args) {
        try {
            for (FactoryAnnotationPair pair : this.typeBasedCustomizerFactories) {
                pair.factory.createForType(pair.annotation, this.sqlObjectType).apply(stmt);
            }
            for (FactoryAnnotationPair pair : this.methodBasedCustomizerFactories) {
                pair.factory.createForMethod(pair.annotation, this.sqlObjectType, this.method).apply(stmt);
            }
            for (FactoryAnnotationParameterIndex param : this.paramBasedCustomizerFactories) {
                param.factory.createForParameter(param.annotation, this.sqlObjectType, this.method, param.parameter, param.index, args[param.index]).apply(stmt);
            }
        }
        catch (SQLException e) {
            throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, stmt.getContext());
        }
    }

    Method getMethod() {
        return this.method;
    }

    static RowMapper<?> rowMapperFor(GetGeneratedKeys ggk, Type returnType) {
        if (GetGeneratedKeys.DefaultMapper.class.equals(ggk.value())) {
            return new GetGeneratedKeys.DefaultMapper(returnType, ggk.columnName());
        }
        try {
            return ggk.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException("Unable to instantiate row mapper for statement", (Throwable)e, null);
        }
    }

    private static class FactoryAnnotationParameterIndex {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;
        private final Parameter parameter;
        private final int index;

        FactoryAnnotationParameterIndex(SqlStatementCustomizerFactory factory, Annotation annotation, Parameter parameter, int index) {
            this.factory = factory;
            this.annotation = annotation;
            this.parameter = parameter;
            this.index = index;
        }
    }

    private static class FactoryAnnotationPair {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;

        FactoryAnnotationPair(SqlStatementCustomizerFactory factory, Annotation annotation) {
            this.factory = factory;
            this.annotation = annotation;
        }
    }
}

