/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@ConfiguringAnnotation(value=Impl.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterBeanMapper {
    public Class<?>[] value();

    public String[] prefix() default {};

    public static class Impl
    implements Configurer {
        @Override
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            RegisterBeanMapper registerBeanMapper = (RegisterBeanMapper)annotation;
            Class<?>[] beanClasses = registerBeanMapper.value();
            String[] prefixes = registerBeanMapper.prefix();
            RowMappers mappers = (RowMappers)registry.get(RowMappers.class);
            if (prefixes.length == 0) {
                for (Class<?> beanClass : beanClasses) {
                    mappers.register(BeanMapper.of(beanClass));
                }
            } else if (prefixes.length == beanClasses.length) {
                for (int i = 0; i < beanClasses.length; ++i) {
                    mappers.register(BeanMapper.of(beanClasses[i], (String)prefixes[i]));
                }
            } else {
                throw new IllegalStateException("RegisterBeanMapper.prefix() must have the same number of elements as value()");
            }
        }

        @Override
        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }
    }
}

