/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.ResultReturner;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlQuery {
    public String value() default "";

    public static class QueryHandler
    extends CustomizingStatementHandler {
        private final Class<?> sqlObjectType;
        private final Method method;
        private final ResultReturner magic;

        QueryHandler(Class<?> sqlObjectType, Method method, ResultReturner magic) {
            super(sqlObjectType, method);
            this.sqlObjectType = sqlObjectType;
            this.method = method;
            this.magic = magic;
        }

        @Override
        public Object invoke(Object target, Object[] args, HandleSupplier handle) {
            String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.method);
            Query q = handle.getHandle().createQuery(sql);
            this.applyCustomizers((SqlStatement<?>)q, args);
            return this.magic.map(this.method, q);
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new QueryHandler(sqlObjectType, method, ResultReturner.forMethod(sqlObjectType, method));
        }
    }
}

