/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.OutParameters;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlCall {
    public String value() default "";

    public static class CallHandler
    extends CustomizingStatementHandler {
        private final Class<?> sqlObjectType;
        private final boolean returnOutParams;

        CallHandler(Class<?> sqlObjectType, Method method) {
            super(sqlObjectType, method);
            this.sqlObjectType = sqlObjectType;
            Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
            Class returnClass = GenericTypes.getErasedType((Type)returnType);
            if (Void.TYPE.equals(returnClass)) {
                this.returnOutParams = false;
            } else if (OutParameters.class.isAssignableFrom(returnClass)) {
                this.returnOutParams = true;
            } else {
                throw new IllegalArgumentException("@SqlCall methods may only return null or OutParameters at present");
            }
        }

        @Override
        public Object invoke(Object target, Object[] args, HandleSupplier handle) {
            String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, this.getMethod());
            Call call = handle.getHandle().createCall(sql);
            this.applyCustomizers((SqlStatement<?>)call, args);
            OutParameters ou = call.invoke();
            if (this.returnOutParams) {
                return ou;
            }
            return null;
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new CallHandler(sqlObjectType, method);
        }
    }
}

