/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.sqlobject.config.ConfigurerFactory;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Factory.class)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterCollectorFactory {
    public Class<? extends CollectorFactory>[] value();

    public static class Factory
    implements ConfigurerFactory {
        @Override
        public Consumer<ConfigRegistry> createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterCollectorFactory)annotation);
        }

        @Override
        public Consumer<ConfigRegistry> createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterCollectorFactory)annotation);
        }

        private Consumer<ConfigRegistry> create(RegisterCollectorFactory annotation) {
            ArrayList<CollectorFactory> factories = new ArrayList<CollectorFactory>();
            for (Class<? extends CollectorFactory> type : annotation.value()) {
                try {
                    factories.add(type.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Unable to instantiate container factory", e);
                }
            }
            return config -> factories.forEach(arg_0 -> ((JdbiCollectors)((JdbiCollectors)config.get(JdbiCollectors.class))).register(arg_0));
        }
    }
}

