/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import org.jdbi.v3.core.HandleSupplier;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.sqlobject.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.ResultReturner;
import org.jdbi.v3.sqlobject.SqlObjects;

class QueryHandler
extends CustomizingStatementHandler {
    private final Class<?> sqlObjectType;
    private final ResultReturner magic;

    QueryHandler(Class<?> sqlObjectType, Method method, ResultReturner magic) {
        super(sqlObjectType, method);
        this.sqlObjectType = sqlObjectType;
        this.magic = magic;
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args, HandleSupplier handle) {
        String sql = ((SqlObjects)handle.getConfig(SqlObjects.class)).getSqlLocator().locate(this.sqlObjectType, method);
        Query q = handle.getHandle().createQuery(sql);
        this.applyCustomizers((SqlStatement<?>)q, args);
        this.applyBinders((SqlStatement<?>)q, args);
        return this.magic.map(method, q);
    }
}

