/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.mapper.FieldMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterFieldMapper {
    public Class<?>[] value();

    public String[] prefix() default {};

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterFieldMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterFieldMapper)annotation);
        }

        private SqlStatementCustomizer create(RegisterFieldMapper annotation) {
            Class<?>[] types = annotation.value();
            String[] prefixes = annotation.prefix();
            ArrayList<RowMapperFactory> mappers = new ArrayList<RowMapperFactory>(types.length);
            if (prefixes.length == 0) {
                for (Class<?> type : types) {
                    mappers.add(FieldMapper.of(type));
                }
            } else if (prefixes.length == types.length) {
                for (int i = 0; i < types.length; ++i) {
                    mappers.add(FieldMapper.of(types[i], (String)prefixes[i]));
                }
            } else {
                throw new IllegalStateException("RegisterFieldMapper.prefix() must have the same number of elements as value()");
            }
            return stmt -> mappers.forEach(arg_0 -> ((SqlStatement)stmt).registerRowMapper(arg_0));
        }
    }
}

