/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.unstable;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jdbi.v3.core.util.GenericTypes;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.BindingAnnotation;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.unstable.ReflectionArrayIterator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=CustomizerFactory.class)
@BindingAnnotation(value=BindingFactory.class)
public @interface BindIn {
    public String value();

    public EmptyHandling onEmpty() default EmptyHandling.THROW;

    public static enum EmptyHandling {
        VOID,
        NULL,
        THROW;

        static final String valueNotHandledMessage = "EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.";
    }

    public static final class Util {
        private Util() {
        }

        static Iterator<?> toIterator(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot make iterator of null");
            }
            if (obj instanceof Iterable) {
                return ((Iterable)obj).iterator();
            }
            if (obj.getClass().isArray()) {
                if (obj instanceof Object[]) {
                    return Arrays.asList((Object[])obj).iterator();
                }
                return new ReflectionArrayIterator(obj);
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        static int size(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot get size of null");
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).size();
            }
            if (obj instanceof Iterable) {
                Iterable iterable = (Iterable)obj;
                int size = 0;
                for (Object x : iterable) {
                    ++size;
                }
                return size;
            }
            if (obj.getClass().isArray()) {
                return Array.getLength(obj);
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        private static String getTypeWarning(Class<?> type) {
            return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + type.getName() + " instead";
        }
    }

    public static class BindingFactory
    implements BinderFactory<BindIn, Object> {
        @Override
        public Binder<BindIn, Object> build(BindIn bindIn) {
            String key = bindIn.value();
            return (q, param, index, bind, arg) -> {
                block7: {
                    block6: {
                        if (arg != null && Util.size(arg) != 0) break block6;
                        switch (bindIn.onEmpty()) {
                            case VOID: {
                                break block7;
                            }
                            case NULL: {
                                q.bind("__" + key + "_0", (String)null);
                                break block7;
                            }
                            case THROW: {
                                IllegalArgumentException inner = new IllegalArgumentException("argument is null; null was explicitly forbidden on this instance of BindIn");
                                throw new IllegalStateException("Illegal argument value was caught too late. Please report this to the jdbi developers.", inner);
                            }
                            default: {
                                throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                            }
                        }
                    }
                    Object parameterType = param == null ? Object.class : param.getParameterizedType();
                    Type elementType = (Type)((Object)GenericTypes.findGenericParameter((Type)parameterType, Iterable.class).orElse(Object.class));
                    Iterator<?> it = Util.toIterator(arg);
                    int i = 0;
                    while (it.hasNext()) {
                        q.bindByType("__" + key + "_" + i, it.next(), elementType);
                        ++i;
                    }
                }
            };
        }
    }

    public static final class CustomizerFactory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, Object arg) {
            int size;
            BindIn bindIn;
            block14: {
                block13: {
                    bindIn = (BindIn)annotation;
                    if (arg != null) break block13;
                    switch (bindIn.onEmpty()) {
                        case VOID: {
                            size = 0;
                            break block14;
                        }
                        case NULL: {
                            size = 1;
                            break block14;
                        }
                        case THROW: {
                            throw new IllegalArgumentException("argument is null; null was explicitly forbidden on this instance of BindIn");
                        }
                        default: {
                            throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                        }
                    }
                }
                size = Util.size(arg);
            }
            if (size == 0) {
                switch (bindIn.onEmpty()) {
                    case VOID: {
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    case THROW: {
                        throw new IllegalArgumentException("argument is empty; emptiness was explicitly forbidden on this instance of BindIn");
                    }
                    default: {
                        throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                    }
                }
            }
            String key = bindIn.value();
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    names.append(",");
                }
                names.append(":__").append(key).append("_").append(i);
            }
            String ns = names.toString();
            return q -> q.define(key, (Object)ns);
        }
    }
}

