/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface TransactionIsolation {
    public TransactionIsolationLevel value() default TransactionIsolationLevel.UNKNOWN;

    public static class MyCustomizer
    implements SqlStatementCustomizer {
        private final TransactionIsolationLevel level;

        MyCustomizer(TransactionIsolationLevel level) {
            this.level = level;
        }

        @Override
        public void apply(SqlStatement<?> q) throws SQLException {
            final int initial_level = q.getContext().getConnection().getTransactionIsolation();
            q.addCustomizer(new StatementCustomizer(){

                public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                    this.setTxnIsolation(ctx, level.intValue());
                }

                public void afterExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                    this.setTxnIsolation(ctx, initial_level);
                }

                private void setTxnIsolation(StatementContext ctx, int level) throws SQLException {
                    Connection c = ctx.getConnection();
                    if (c.getTransactionIsolation() != level) {
                        c.setTransactionIsolation(level);
                    }
                }
            });
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return new MyCustomizer(((TransactionIsolation)annotation).value());
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return new MyCustomizer(((TransactionIsolation)annotation).value());
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            assert (arg instanceof TransactionIsolationLevel);
            return new MyCustomizer((TransactionIsolationLevel)arg);
        }
    }
}

