/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.statement.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.ResultReturner;
import org.jdbi.v3.sqlobject.statement.SqlObjectStatementConfiguration;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Factory.class)
public @interface SqlUpdate {
    public String value() default "";

    public static class UpdateHandler
    extends CustomizingStatementHandler<Update> {
        private final Function<Update, Object> returner;

        UpdateHandler(Class<?> sqlObjectType, Method method) {
            super(sqlObjectType, method);
            boolean isGetGeneratedKeys = method.isAnnotationPresent(GetGeneratedKeys.class);
            Type returnType = GenericTypes.resolveType((Type)method.getGenericReturnType(), sqlObjectType);
            if (isGetGeneratedKeys) {
                ResultReturner magic = ResultReturner.forMethod(sqlObjectType, method);
                GetGeneratedKeys ggk = method.getAnnotation(GetGeneratedKeys.class);
                RowMapper<?> mapper = UpdateHandler.rowMapperFor(ggk, returnType);
                this.returner = update -> {
                    String columnName = ggk.columnName();
                    ResultBearing resultBearing = columnName.isEmpty() ? update.executeAndReturnGeneratedKeys(new String[0]) : update.executeAndReturnGeneratedKeys(new String[]{columnName});
                    return magic.result(resultBearing.map(mapper), update.getContext());
                };
            } else if (this.isNumeric(method.getReturnType())) {
                this.returner = update -> update.execute();
            } else if (this.isBoolean(method.getReturnType())) {
                this.returner = update -> update.execute() > 0;
            } else {
                throw new UnableToCreateSqlObjectException(this.invalidReturnTypeMessage(method, returnType));
            }
        }

        @Override
        Update createStatement(Handle handle, String locatedSql) {
            return handle.createUpdate(locatedSql);
        }

        @Override
        void configureReturner(Update u, SqlObjectStatementConfiguration cfg) {
            cfg.setReturner(() -> this.returner.apply(u));
        }

        private boolean isNumeric(Class<?> type) {
            return Number.class.isAssignableFrom(type) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Void.TYPE);
        }

        private boolean isBoolean(Class<?> type) {
            return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
        }

        private String invalidReturnTypeMessage(Method method, Type returnType) {
            return method.getDeclaringClass().getSimpleName() + "." + method.getName() + " method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: " + returnType;
        }
    }

    public static class Factory
    implements HandlerFactory {
        @Override
        public Handler buildHandler(Class<?> sqlObjectType, Method method) {
            return new UpdateHandler(sqlObjectType, method);
        }
    }
}

