/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RegisterCollectorFactory {
    public Class<? extends CollectorFactory>[] value();

    public static class Customizer
    implements SqlStatementCustomizer {
        private final List<CollectorFactory> factories;

        Customizer(RegisterCollectorFactory annotation) {
            ArrayList<CollectorFactory> factories = new ArrayList<CollectorFactory>();
            for (Class<? extends CollectorFactory> type : annotation.value()) {
                try {
                    factories.add(type.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Unable to instantiate container factory", e);
                }
            }
            this.factories = factories;
        }

        @Override
        public void apply(SqlStatement<?> q) throws SQLException {
            if (q instanceof Query) {
                Query query = (Query)q;
                this.factories.forEach(arg_0 -> ((Query)query).registerCollectorFactory(arg_0));
            }
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return new Customizer((RegisterCollectorFactory)annotation);
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return new Customizer((RegisterCollectorFactory)annotation);
        }
    }
}

