/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.Query;
import org.jdbi.v3.core.mapper.BeanMapperFactory;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterBeanMapper {
    public Class<?>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterBeanMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterBeanMapper)annotation);
        }

        private SqlStatementCustomizer create(RegisterBeanMapper annotation) {
            return statement -> {
                Query query = (Query)statement;
                query.registerRowMapper((RowMapperFactory)new BeanMapperFactory((Class[])annotation.value()));
            };
        }
    }
}

