/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.sqlobject.EqualsHandler;
import org.jdbi.v3.sqlobject.FinalizeHandler;
import org.jdbi.v3.sqlobject.GetHandleHelper;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.HashCodeHandler;
import org.jdbi.v3.sqlobject.PassThroughHandler;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;
import org.jdbi.v3.sqlobject.SqlObjectConfig;
import org.jdbi.v3.sqlobject.SqlObjectConfigurerFactory;
import org.jdbi.v3.sqlobject.SqlObjectConfiguringAnnotation;
import org.jdbi.v3.sqlobject.ToStringHandler;
import org.jdbi.v3.sqlobject.TransactionalHelper;
import org.jdbi.v3.sqlobject.mixins.GetHandle;
import org.jdbi.v3.sqlobject.mixins.Transactional;

public enum SqlObjectFactory implements ExtensionFactory<SqlObjectConfig>
{
    INSTANCE;

    private static final MethodInterceptor NO_OP;
    private final Map<Method, Handler> mixinHandlers = new HashMap<Method, Handler>();
    private final ConcurrentMap<Class<?>, Map<Method, Handler>> handlersCache = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Factory> factories = new ConcurrentHashMap();
    private final ConcurrentMap<Class<? extends SqlObjectConfigurerFactory>, SqlObjectConfigurerFactory> configurerFactories = new ConcurrentHashMap<Class<? extends SqlObjectConfigurerFactory>, SqlObjectConfigurerFactory>();

    private SqlObjectFactory() {
        this.mixinHandlers.putAll(TransactionalHelper.handlers());
        this.mixinHandlers.putAll(GetHandleHelper.handlers());
    }

    public SqlObjectConfig createConfig() {
        return new SqlObjectConfig();
    }

    public boolean accepts(Class<?> extensionType) {
        if (GetHandle.class.isAssignableFrom(extensionType) || Transactional.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(a -> a.annotationType().isAnnotationPresent(SqlMethodAnnotation.class));
    }

    public <E> E attach(Class<E> extensionType, SqlObjectConfig config, Supplier<Handle> handle) {
        Factory f = this.factories.computeIfAbsent(extensionType, type -> {
            Enhancer e = new Enhancer();
            e.setClassLoader(extensionType.getClassLoader());
            ArrayList<Class> interfaces = new ArrayList<Class>();
            if (extensionType.isInterface()) {
                interfaces.add(extensionType);
            } else {
                e.setSuperclass(extensionType);
            }
            e.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            e.setCallback((Callback)NO_OP);
            return (Factory)e.create();
        });
        Map<Method, Handler> handlers = this.buildHandlersFor(extensionType);
        MethodInterceptor interceptor = this.createMethodInterceptor(extensionType, config, handlers, handle);
        return extensionType.cast(f.newInstance((Callback)interceptor));
    }

    private Map<Method, Handler> buildHandlersFor(Class<?> sqlObjectType) {
        return this.handlersCache.computeIfAbsent(sqlObjectType, type -> {
            HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
            handlers.putAll(EqualsHandler.handler());
            handlers.putAll(ToStringHandler.handler(sqlObjectType.getName()));
            handlers.putAll(HashCodeHandler.handler());
            handlers.putAll(FinalizeHandler.handlerFor(sqlObjectType));
            for (Method method : sqlObjectType.getMethods()) {
                handlers.computeIfAbsent(method, m -> this.buildMethodHandler(sqlObjectType, (Method)m));
            }
            return handlers;
        });
    }

    private Handler buildMethodHandler(Class<?> sqlObjectType, Method method) {
        if (this.mixinHandlers.containsKey(method)) {
            return this.mixinHandlers.get(method);
        }
        Handler handler = this.buildBaseHandler(sqlObjectType, method);
        return this.addDecorators(handler, sqlObjectType, method);
    }

    private Handler buildBaseHandler(Class<?> sqlObjectType, Method method) {
        Set sqlMethodAnnotations = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlMethodAnnotation.class)).collect(Collectors.toSet());
        if (sqlMethodAnnotations.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive annotations on method %s.%s: %s", sqlObjectType.getName(), method.getName(), sqlMethodAnnotations));
        }
        return sqlMethodAnnotations.stream().map(type -> type.getAnnotation(SqlMethodAnnotation.class)).map(a -> SqlObjectFactory.buildFactory(a.value())).map(factory -> factory.buildHandler(sqlObjectType, method)).findFirst().orElseGet(PassThroughHandler::new);
    }

    private Handler addDecorators(Handler handler, Class<?> sqlObjectType, Method method) {
        List decorators = Stream.of(method.getAnnotations()).map(a -> a.annotationType().getAnnotation(SqlMethodDecoratingAnnotation.class)).filter(Objects::nonNull).map(a -> SqlObjectFactory.buildDecorator(a.value())).collect(Collectors.toList());
        for (HandlerDecorator decorator : decorators) {
            handler = decorator.decorateHandler(handler, sqlObjectType, method);
        }
        return handler;
    }

    private static HandlerFactory buildFactory(Class<? extends HandlerFactory> factoryClazz) {
        HandlerFactory factory;
        try {
            factory = factoryClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Factory class " + factoryClazz + "cannot be instantiated", e);
        }
        return factory;
    }

    private static HandlerDecorator buildDecorator(Class<? extends HandlerDecorator> decoratorClass) {
        HandlerDecorator decorator;
        try {
            decorator = decoratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Decorator class " + decoratorClass + "cannot be instantiated", e);
        }
        return decorator;
    }

    private MethodInterceptor createMethodInterceptor(Class<?> sqlObjectType, SqlObjectConfig baseConfig, Map<Method, Handler> handlers, Supplier<Handle> handle) {
        return (proxy, method, args, methodProxy) -> {
            Handler handler = (Handler)handlers.get(method);
            if (handler == null) {
                return methodProxy.invokeSuper(proxy, args);
            }
            SqlObjectConfig config = baseConfig.createCopy();
            this.forEachConfigurerFactory(sqlObjectType, (factory, annotation) -> factory.createForType((Annotation)annotation, sqlObjectType).accept(config));
            this.forEachConfigurerFactory(method, (factory, annotation) -> factory.createForMethod((Annotation)annotation, sqlObjectType, method).accept(config));
            return handler.invoke(handle, config, proxy, args, method);
        };
    }

    private void forEachConfigurerFactory(AnnotatedElement element, BiConsumer<SqlObjectConfigurerFactory, Annotation> consumer) {
        Stream.of(element.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(SqlObjectConfiguringAnnotation.class)).forEach(a -> {
            SqlObjectConfiguringAnnotation meta = a.annotationType().getAnnotation(SqlObjectConfiguringAnnotation.class);
            consumer.accept(this.getConfigurerFactory(meta.value()), (Annotation)a);
        });
    }

    private SqlObjectConfigurerFactory getConfigurerFactory(Class<? extends SqlObjectConfigurerFactory> factoryClass) {
        return this.configurerFactories.computeIfAbsent(factoryClass, c -> {
            try {
                return (SqlObjectConfigurerFactory)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to instantiate configurer factory class " + factoryClass, e);
            }
        });
    }

    static {
        NO_OP = (proxy, method, args, methodProxy) -> null;
    }
}

