/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.SqlStatement;
import org.jdbi.v3.core.exception.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.Bind;
import org.jdbi.v3.sqlobject.BinderFactory;
import org.jdbi.v3.sqlobject.Bindifier;
import org.jdbi.v3.sqlobject.BindingAnnotation;
import org.jdbi.v3.sqlobject.DefaultObjectBinder;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

abstract class CustomizingStatementHandler
implements Handler {
    private final List<Bindifier<?>> binders = new ArrayList();
    private final List<FactoryAnnotationPair> typeBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationPair> methodBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationIndexTriple> paramBasedCustomizerFactories = new ArrayList<FactoryAnnotationIndexTriple>();
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> sqlObjectType, Method method) {
        this.sqlObjectType = sqlObjectType;
        this.method = method;
        for (Annotation annotation : sqlObjectType.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            if (!annotation.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation a = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = a.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create sql statement customizer factory", e);
            }
            this.typeBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        for (Annotation annotation : method.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation scf = annotationType.getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = scf.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate statement customizer factory", e);
            }
            this.methodBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int paramIndex = 0; paramIndex < paramAnnotations.length; ++paramIndex) {
            boolean thereBindingAnnotation = false;
            for (Annotation annotation : paramAnnotations[paramIndex]) {
                SqlStatementCustomizerFactory f;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.isAnnotationPresent(BindingAnnotation.class)) {
                    BindingAnnotation ba = annotationType.getAnnotation(BindingAnnotation.class);
                    try {
                        BinderFactory<?, ?> fact = ba.value().newInstance();
                        this.binders.add(new Bindifier<Annotation>(this.method, annotation, paramIndex, fact.build(annotation)));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("unable to instantiate customizer", e);
                    }
                    thereBindingAnnotation = true;
                }
                if (!annotationType.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
                SqlStatementCustomizingAnnotation sca = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
                try {
                    f = sca.value().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate sql statement customizer factory", e);
                }
                this.paramBasedCustomizerFactories.add(new FactoryAnnotationIndexTriple(f, annotation, paramIndex));
                thereBindingAnnotation = true;
            }
            if (thereBindingAnnotation) continue;
            this.binders.add(new Bindifier<Bind>(method, null, paramIndex, new DefaultObjectBinder()));
        }
    }

    protected void applyBinders(SqlStatement<?> q, Object[] args) {
        for (Bindifier<?> binder : this.binders) {
            binder.bind(q, args);
        }
    }

    protected void applyCustomizers(SqlStatement<?> q, Object[] args) {
        for (FactoryAnnotationPair pair : this.typeBasedCustomizerFactories) {
            try {
                pair.factory.createForType(pair.annotation, this.sqlObjectType).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
            }
        }
        for (FactoryAnnotationPair pair : this.methodBasedCustomizerFactories) {
            try {
                pair.factory.createForMethod(pair.annotation, this.sqlObjectType, this.method).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
            }
        }
        if (args != null) {
            for (FactoryAnnotationIndexTriple triple : this.paramBasedCustomizerFactories) {
                try {
                    triple.factory.createForParameter(triple.annotation, this.sqlObjectType, this.method, args[triple.index]).apply(q);
                }
                catch (SQLException e) {
                    throw new UnableToCreateStatementException("unable to apply customizer", (Throwable)e, q.getContext());
                }
            }
        }
    }

    protected Method getMethod() {
        return this.method;
    }

    private static class FactoryAnnotationIndexTriple {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;
        private final int index;

        FactoryAnnotationIndexTriple(SqlStatementCustomizerFactory factory, Annotation annotation, int index) {
            this.factory = factory;
            this.annotation = annotation;
            this.index = index;
        }
    }

    private static class FactoryAnnotationPair {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;

        FactoryAnnotationPair(SqlStatementCustomizerFactory factory, Annotation annotation) {
            this.factory = factory;
            this.annotation = annotation;
        }
    }
}

