/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jdbi.v3.sqlobject.BindBean;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;

class BindBeanFactory
implements BinderFactory<BindBean, Object> {
    BindBeanFactory() {
    }

    @Override
    public Binder<BindBean, Object> build(BindBean annotation) {
        return (q, param, index, bind, arg) -> {
            String prefix = "___jdbi_bare___".equals(bind.value()) ? "" : bind.value() + ".";
            try {
                PropertyDescriptor[] props;
                BeanInfo infos = Introspector.getBeanInfo(arg.getClass());
                for (PropertyDescriptor prop : props = infos.getPropertyDescriptors()) {
                    Method readMethod;
                    if (Objects.equals("class", prop.getName()) || (readMethod = prop.getReadMethod()) == null) continue;
                    q.bindByType(prefix + prop.getName(), readMethod.invoke(arg, new Object[0]), readMethod.getGenericReturnType());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to bind bean properties", e);
            }
        };
    }
}

