/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import oracle.jdbc.OraclePreparedStatement;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultProducers;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.meta.Beta;

@Beta
public class OracleReturning {
    private OracleReturning() {
    }

    public static ReturnParameters returnParameters() {
        return new ReturnParameters();
    }

    public static ResultProducer<ResultBearing> returningDml() {
        return (supplier, ctx) -> ResultProducers.createResultBearing((Supplier)supplier, statement -> OracleReturning.unwrapOracleStatement(statement).getReturnResultSet(), (StatementContext)ctx);
    }

    private static OraclePreparedStatement unwrapOracleStatement(Statement stmt) throws SQLException {
        if (!stmt.isWrapperFor(OraclePreparedStatement.class)) {
            throw new IllegalStateException("Statement is not an instance of, nor a wrapper of, OraclePreparedStatement");
        }
        return stmt.unwrap(OraclePreparedStatement.class);
    }

    public static class ReturnParameters
    implements StatementCustomizer {
        private final List<ReturnParam> returnParams = new ArrayList<ReturnParam>();

        ReturnParameters() {
        }

        public void beforeBinding(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            for (ReturnParam returnParam : this.returnParams) {
                returnParam.bind(ctx.getBinding());
            }
        }

        public ReturnParameters register(int index, int oracleType) {
            this.returnParams.add(new ReturnParam(index, oracleType));
            return this;
        }

        public ReturnParameters register(String name, int oracleType) {
            this.returnParams.add(new ReturnParam(name, oracleType));
            return this;
        }
    }

    static class ReturnParam
    implements Argument {
        private final String name;
        private final int index;
        private final int oracleType;

        ReturnParam(String name, int oracleType) {
            this.name = name;
            this.index = -1;
            this.oracleType = oracleType;
        }

        ReturnParam(int index, int oracleType) {
            this.name = null;
            this.index = index;
            this.oracleType = oracleType;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            OracleReturning.unwrapOracleStatement(statement).registerReturnParameter(position, this.oracleType);
        }

        void bind(Binding binding) {
            if (this.name == null) {
                binding.addPositional(this.index, (Argument)this);
            } else {
                binding.addNamed(this.name, (Argument)this);
            }
        }
    }
}

