/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.testing.JdbiRule;
import org.testcontainers.containers.OracleContainer;

public class OracleDatabaseRule
extends JdbiRule {
    private final String uri;
    private final String username;
    private final String password;

    public OracleDatabaseRule(OracleContainer oracleContainer) {
        this.uri = oracleContainer.getJdbcUrl();
        this.username = oracleContainer.getUsername();
        this.password = oracleContainer.getPassword();
    }

    protected DataSource createDataSource() {
        try {
            OracleDataSource dataSource = new OracleDataSource();
            dataSource.setURL(this.uri);
            dataSource.setUser(this.username);
            dataSource.setPassword(this.password);
            return dataSource;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void createTables(OracleContainer oracleContainer) throws SQLException {
        try (Connection connection = oracleContainer.createConnection("");){
            Jdbi jdbi = Jdbi.create((Connection)connection);
            jdbi.withHandle(handle -> {
                handle.execute("create sequence something_id_sequence INCREMENT BY 1 START WITH 100", new Object[0]);
                handle.execute("create table something (name varchar(200), id int, constraint something_id primary key (id))", new Object[0]);
                return null;
            });
        }
    }
}

