/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jackson2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.jackson2.Jackson2Config;
import org.jdbi.v3.json.JsonMapper;

class JacksonJsonMapper
implements JsonMapper {
    JacksonJsonMapper() {
    }

    public JsonMapper.TypedJsonMapper forType(final Type type, final ConfigRegistry config) {
        return new JsonMapper.TypedJsonMapper(){
            private final ObjectMapper mapper;
            private final JavaType mappedType;
            private final ObjectReader reader;
            private final ObjectWriter writer;
            final /* synthetic */ JacksonJsonMapper this$0;
            {
                this.this$0 = this$0;
                this.mapper = ((Jackson2Config)config.get(Jackson2Config.class)).getMapper();
                this.mappedType = this.mapper.constructType(type);
                this.reader = this.mapper.readerFor(this.mappedType);
                this.writer = this.mapper.writerFor(this.mappedType);
            }

            public String toJson(Object value, ConfigRegistry config2) {
                Class<?> view = ((Jackson2Config)config2.get(Jackson2Config.class)).getSerializationView();
                ObjectWriter viewWriter = view == null ? this.writer : this.writer.withView(view);
                try {
                    return viewWriter.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new UnableToProduceResultException((Throwable)e);
                }
            }

            public Object fromJson(String json, ConfigRegistry config2) {
                Class<?> view = ((Jackson2Config)config2.get(Jackson2Config.class)).getDeserializationView();
                ObjectReader viewReader = view == null ? this.reader : this.reader.withView(view);
                try {
                    return viewReader.readValue(json);
                }
                catch (IOException e) {
                    throw new UnableToProduceResultException((Throwable)e);
                }
            }
        };
    }
}

