/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;

public final class InternalLooseImportBindingBuilder<T>
implements ScopedBindingBuilder {
    private final InternalBindingProvider<T> provider;
    private final Key<T> concreteType;
    private final ScopedBindingBuilder scopedBindingBuilder;

    public static <T> InternalLooseImportBindingBuilder<T> createLooseBinding(LinkedBindingBuilder<T> binder, Key<T> concreteType) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        Preconditions.checkNotNull(concreteType, (Object)"concreteType is null");
        return new InternalLooseImportBindingBuilder<T>(binder, concreteType);
    }

    private InternalLooseImportBindingBuilder(LinkedBindingBuilder<T> binder, Key<T> concreteType) {
        this.concreteType = concreteType;
        this.provider = new InternalBindingProvider<T>(concreteType);
        this.scopedBindingBuilder = binder.toProvider(this.provider);
    }

    public InternalLooseImportBindingBuilder<T> withDefault(@Nullable T value) {
        this.provider.setDefaultValue(value);
        return this;
    }

    public ScopedBindingBuilder to(Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return this.to(TypeLiteral.get(clazz));
    }

    public ScopedBindingBuilder to(TypeLiteral<? extends T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.provider.setKey(this.concreteType.ofType(type));
        return this;
    }

    public void in(Class<? extends Annotation> scopeAnnotation) {
        Preconditions.checkNotNull(scopeAnnotation, (Object)"scopeAnnotation is null");
        this.scopedBindingBuilder.in(scopeAnnotation);
    }

    public void in(Scope scope) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope is null");
        this.scopedBindingBuilder.in(scope);
    }

    public void asEagerSingleton() {
        this.scopedBindingBuilder.asEagerSingleton();
    }

    static final class InternalBindingProvider<T>
    implements Provider<T> {
        private Key<? extends T> key;
        private T defaultValue;
        private Injector injector;

        InternalBindingProvider(Key<? extends T> key) {
            this.key = (Key)Preconditions.checkNotNull(key, (Object)"key is null");
        }

        InternalBindingProvider<T> setKey(Key<? extends T> key) {
            this.key = (Key)Preconditions.checkNotNull(key, (Object)"key is null");
            return this;
        }

        InternalBindingProvider<T> setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Inject
        void setInjector(Injector injector) {
            Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
            Preconditions.checkState((this.injector == null ? 1 : 0) != 0, (Object)"setInjector() called multiple times!");
            this.injector = injector;
        }

        @Nullable
        public T get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"calling get() before setInjector()!");
            if (this.injector.getExistingBinding(this.key) == null) {
                return this.defaultValue;
            }
            return (T)this.injector.getInstance(this.key);
        }
    }
}

