/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.base.Optional;
import java.lang.reflect.Type;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

public class GuavaArguments {
    public static ArgumentFactory factory() {
        return new Factory();
    }

    private static class Factory
    implements ArgumentFactory {
        private Factory() {
        }

        public java.util.Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
            if (value instanceof Optional) {
                Object nestedValue = ((Optional)value).orNull();
                Type nestedType = this.findOptionalType(expectedType, nestedValue);
                return ((Arguments)config.get(Arguments.class)).findFor(nestedType, nestedValue);
            }
            return java.util.Optional.empty();
        }

        private Type findOptionalType(Type wrapperType, Object nestedValue) {
            java.util.Optional nestedType;
            if (GenericTypes.getErasedType((Type)wrapperType).equals(Optional.class) && (nestedType = GenericTypes.findGenericParameter((Type)wrapperType, Optional.class)).isPresent()) {
                return (Type)nestedType.get();
            }
            return nestedValue == null ? Object.class : nestedValue.getClass();
        }
    }
}

