/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.awt;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jcodec.api.SequenceEncoder;
import org.jcodec.common.Codec;
import org.jcodec.common.Format;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Rational;
import org.jcodec.scale.AWTUtil;

public class AWTSequenceEncoder
extends SequenceEncoder {
    public AWTSequenceEncoder(SeekableByteChannel out, Rational fps) throws IOException {
        super(out, fps, Format.MOV, Codec.H264, null);
    }

    public static AWTSequenceEncoder createSequenceEncoder(File out, int fps) throws IOException {
        return new AWTSequenceEncoder((SeekableByteChannel)NIOUtils.writableChannel((File)out), Rational.R((int)fps, (int)1));
    }

    public static AWTSequenceEncoder create25Fps(File out) throws IOException {
        return new AWTSequenceEncoder((SeekableByteChannel)NIOUtils.writableChannel((File)out), Rational.R((int)25, (int)1));
    }

    public static AWTSequenceEncoder create30Fps(File out) throws IOException {
        return new AWTSequenceEncoder((SeekableByteChannel)NIOUtils.writableChannel((File)out), Rational.R((int)30, (int)1));
    }

    public static AWTSequenceEncoder create2997Fps(File out) throws IOException {
        return new AWTSequenceEncoder((SeekableByteChannel)NIOUtils.writableChannel((File)out), Rational.R((int)30000, (int)1001));
    }

    public static AWTSequenceEncoder create24Fps(File out) throws IOException {
        return new AWTSequenceEncoder((SeekableByteChannel)NIOUtils.writableChannel((File)out), Rational.R((int)24, (int)1));
    }

    public void encodeImage(BufferedImage bi) throws IOException {
        this.encodeNativeFrame(AWTUtil.fromBufferedImageRGB(bi));
    }
}

