/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.AzureBlobAsyncClient;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;

@Singleton
public class AzureBlobRequestSigner
implements BlobRequestSigner {
    private final Function<Invocation, HttpRequest> processor;
    private final BlobToAzureBlob blobToBlob;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;

    @Inject
    public AzureBlobRequestSigner(Function<Invocation, HttpRequest> processor, BlobToAzureBlob blobToBlob, BlobToHttpGetOptions blob2HttpGetOptions) throws SecurityException, NoSuchMethodException {
        this.processor = (Function)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToBlob = (BlobToAzureBlob)Preconditions.checkNotNull((Object)blobToBlob, (Object)"blobToBlob");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = Reflection2.method(AzureBlobAsyncClient.class, (String)"getBlob", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(AzureBlobAsyncClient.class, (String)"deleteBlob", (Class[])new Class[]{String.class, String.class});
        this.createMethod = Reflection2.method(AzureBlobAsyncClient.class, (String)"putBlob", (Class[])new Class[]{String.class, AzureBlob.class});
    }

    public HttpRequest signGetBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)))));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToBlob.apply(blob))))));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.deleteMethod, (List)ImmutableList.of((Object)container, (Object)name)))));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name, (Object)this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")))))));
    }
}

