/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.strategy.MkdirStrategy;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;

@Singleton
public class MarkerFileMkdirStrategy
implements MkdirStrategy {
    @Inject(optional=true)
    @Named(value="jclouds.blobstore.directorysuffix")
    protected String directorySuffix = "";
    private final BlobStore connection;

    @Inject
    MarkerFileMkdirStrategy(BlobStore connection) {
        this.connection = connection;
    }

    @Override
    public void execute(String containerName, String directory) {
        Blob blob = this.connection.newBlob(directory + this.directorySuffix);
        blob.setPayload((Payload)Payloads.newByteArrayPayload((byte[])new byte[0]));
        blob.getPayload().getContentMetadata().setContentType("application/directory");
        blob.getMetadata().setType(StorageType.RELATIVE_PATH);
        this.connection.putBlob(containerName, blob);
    }
}

