/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.internal.BaseBlobMap;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;

public class BlobMapImpl
extends BaseBlobMap<Blob>
implements BlobMap {
    @Inject
    public BlobMapImpl(BlobStore blobstore, GetBlobsInListStrategy getAllBlobs, ContainsValueInListStrategy containsValueStrategy, PutBlobsStrategy putBlobsStrategy, ListContainerAndRecurseThroughFolders listStrategy, String containerName, ListContainerOptions options) {
        super(blobstore, getAllBlobs, containsValueStrategy, putBlobsStrategy, listStrategy, containerName, options);
    }

    @Override
    public Blob get(Object key) {
        String realKey = (String)this.prefixer.apply((Object)key.toString());
        Blob blob = this.blobstore.getBlob(this.containerName, realKey);
        return blob != null ? this.stripPrefix(blob) : null;
    }

    @Override
    public Blob put(String key, Blob value) {
        Blob returnVal = this.getLastValue(key);
        this.blobstore.putBlob(this.containerName, value);
        return returnVal;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Blob> map) {
        this.putBlobsStrategy.execute(this.containerName, map.values());
    }

    @Override
    public Blob remove(Object key) {
        Blob old = this.getLastValue(key);
        String realKey = (String)this.prefixer.apply((Object)key.toString());
        this.blobstore.removeBlob(this.containerName, realKey);
        return old;
    }

    private Blob getLastValue(Object key) {
        Blob old;
        try {
            old = this.get(key);
        }
        catch (KeyNotFoundException e) {
            old = null;
        }
        return old;
    }

    @Override
    public Collection<Blob> values() {
        return Sets.newLinkedHashSet(this.getAllBlobs.execute(this.containerName, this.options));
    }

    @Override
    public Blob newBlob(String name) {
        return this.blobstore.newBlob(name);
    }
}

