/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.concurrent.Futures;
import org.jclouds.domain.Location;
import org.jclouds.util.Assertions;

public abstract class BaseAsyncBlobStore
implements AsyncBlobStore {
    protected final BlobStoreContext context;
    protected final BlobUtils blobUtils;
    protected final ExecutorService service;
    protected final Supplier<Location> defaultLocation;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected BaseAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations) {
        this.context = (BlobStoreContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.blobUtils = (BlobUtils)Preconditions.checkNotNull((Object)blobUtils, (Object)"blobUtils");
        this.service = (ExecutorService)Preconditions.checkNotNull((Object)service, (Object)"service");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public Blob newBlob(String name) {
        return this.blobUtils.newBlob(name);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public ListenableFuture<Long> countBlobs(String container) {
        return this.countBlobs(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public ListenableFuture<Long> countBlobs(final String containerName, final ListContainerOptions options) {
        return Futures.makeListenable(this.service.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return BaseAsyncBlobStore.this.blobUtils.countBlobs(containerName, options);
            }
        }), (ExecutorService)this.service);
    }

    @Override
    public ListenableFuture<Void> clearContainer(String container) {
        return this.clearContainer(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public ListenableFuture<Void> clearContainer(final String containerName, final ListContainerOptions options) {
        return Futures.makeListenable(this.service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.clearContainer(containerName, options);
                return null;
            }
        }), (ExecutorService)this.service);
    }

    @Override
    public ListenableFuture<Void> deleteDirectory(final String containerName, final String directory) {
        return Futures.makeListenable(this.service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.deleteDirectory(containerName, directory);
                return null;
            }
        }), (ExecutorService)this.service);
    }

    @Override
    public ListenableFuture<Boolean> directoryExists(final String containerName, final String directory) {
        return Futures.makeListenable(this.service.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BaseAsyncBlobStore.this.blobUtils.directoryExists(containerName, directory);
            }
        }), (ExecutorService)this.service);
    }

    @Override
    public ListenableFuture<Void> createDirectory(final String containerName, final String directory) {
        return this.blobUtils.directoryExists(containerName, directory) ? com.google.common.util.concurrent.Futures.immediateFuture((Object)null) : Futures.makeListenable(this.service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.createDirectory(containerName, directory);
                return null;
            }
        }), (ExecutorService)this.service);
    }

    @Override
    public ListenableFuture<Blob> getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    @Override
    public ListenableFuture<Void> deleteContainer(final String container) {
        return Futures.makeListenable(this.service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.deleteAndEnsurePathGone(container);
                return null;
            }
        }), (ExecutorService)this.service);
    }

    protected void deleteAndEnsurePathGone(final String container) {
        try {
            if (!Assertions.eventuallyTrue((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        BaseAsyncBlobStore.this.clearContainer(container, ListContainerOptions.Builder.recursive());
                        return BaseAsyncBlobStore.this.deleteAndVerifyContainerGone(container);
                    }
                    catch (ContainerNotFoundException e) {
                        return true;
                    }
                }
            }, (long)30000L)) {
                throw new IllegalStateException(container + " still exists after deleting!");
            }
        }
        catch (InterruptedException e) {
            new IllegalStateException(container + " interrupted during deletion!", e);
        }
    }

    @Override
    public ListenableFuture<Set<? extends Location>> listAssignableLocations() {
        return com.google.common.util.concurrent.Futures.immediateFuture((Object)this.locations.get());
    }

    protected abstract boolean deleteAndVerifyContainerGone(String var1);
}

