/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.io.ContentMetadata;

@Singleton
public class TransientBlobRequestSigner
implements BlobRequestSigner {
    private final BasicAuthentication basicAuth;

    @Inject
    public TransientBlobRequestSigner(BasicAuthentication basicAuth) {
        this.basicAuth = (BasicAuthentication)Preconditions.checkNotNull((Object)basicAuth, (Object)"basicAuth");
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        HttpRequest request = new HttpRequest("GET", URI.create(String.format("http://localhost/%s/%s", container, name)));
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create(String.format("http://localhost/%s/%s", container, blob.getMetadata().getName()))).payload(blob.getPayload()).headers(HttpUtils.getContentHeadersFromMetadata((ContentMetadata)blob.getMetadata().getContentMetadata())).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        HttpRequest request = new HttpRequest("DELETE", URI.create(String.format("http://localhost/%s/%s", container, name)));
        return this.basicAuth.filter(request);
    }
}

