/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.runtime;

import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.runtime.MutableToken;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.bpm.runtime.BasicExecutionContext;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;
import org.jboss.util.id.UID;

public class TokenImpl
implements MutableToken {
    private String id;
    private SequenceFlow flow;
    private ExecutionContext context;
    private InputSet inputSet;
    private OutputSet outputSet;
    private Token.TokenStatus status;

    public TokenImpl(Attachments att) {
        this.context = new BasicExecutionContext(att);
        this.id = new UID().toString();
        this.status = Token.TokenStatus.Created;
    }

    public String getTokenID() {
        return this.id;
    }

    public Token.TokenStatus getTokenStatus() {
        return this.status;
    }

    public void setTokenStatus(Token.TokenStatus status) {
        this.status = status;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public SequenceFlow getFlow() {
        return this.flow;
    }

    public void setFlow(SequenceFlow flow) {
        this.flow = flow;
    }

    public InputSet getInputSet() {
        return this.inputSet;
    }

    public void setInputSet(InputSet inputSet) {
        this.inputSet = inputSet;
    }

    public OutputSet getOutputSet() {
        return this.outputSet;
    }

    public void setOutputSet(OutputSet outputSet) {
        this.outputSet = outputSet;
    }

    public Token copyToken() {
        return new TokenImpl((Attachments)this.context);
    }

    public void mergeToken(Token token) {
        ExecutionContext mergeContext = token.getExecutionContext();
        for (Attachments.Key key : mergeContext.getAttachmentKeys()) {
            Object mergeValue = mergeContext.getAttachment(key.getClassPart(), key.getNamePart());
            Object existValue = this.context.getAttachment(key.getClassPart(), key.getNamePart());
            if (existValue != null && !existValue.equals(mergeValue)) {
                throw new IllegalStateException("Cannot merge the same key with different values: " + key);
            }
            this.context.addAttachment(key.getClassPart(), key.getNamePart(), mergeValue);
        }
    }

    public String toString() {
        return "[sf=" + this.getFlow() + ",status=" + this.getTokenStatus() + ",ctx=" + this.getExecutionContext() + "]";
    }
}

