/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.InvalidProcessException;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.EndEvent;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MutablePropertySupport;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.ri.model.impl.AssignmentImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.MessageImpl;
import org.jboss.bpm.ri.model.impl.SupportingElementImpl;
import org.jboss.bpm.runtime.Attachments;
import org.jboss.util.id.UID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessImpl
extends SupportingElementImpl
implements Process,
MutablePropertySupport {
    private static final Log log = LogFactory.getLog(ProcessImpl.class);
    private String name;
    private List<FlowObject> flowObjects = new ArrayList<FlowObject>();
    private List<Message> messages = new ArrayList<Message>();
    private List<Property> props = new ArrayList<Property>();
    private List<Assignment> assignments = new ArrayList<Assignment>();
    private Process.ProcessStatus status = Process.ProcessStatus.None;
    private RuntimeException runtimeException;

    @Override
    public ObjectName getID() {
        if (this.id == null) {
            StringBuilder str = new StringBuilder("jboss.bpm:");
            str.append("type=Process,name=" + this.getName() + ",id=" + new UID());
            this.id = ObjectNameFactory.create((String)str.toString());
        }
        return this.id;
    }

    public ProcessImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Assignment> getAssignments() {
        return Collections.unmodifiableList(this.assignments);
    }

    public void addAssignment(AssignmentImpl assignment) {
        this.assignments.add(assignment);
    }

    public List<InputSet> getInputSets() {
        throw new NotImplementedException("JBPM-1644", "Process InputSets");
    }

    public List<OutputSet> getOutputSets() {
        throw new NotImplementedException("JBPM-1645", "Process OutputSets");
    }

    public List<String> getPerformers() {
        throw new NotImplementedException("JBPM-1646", "Process Performers");
    }

    public Process.ProcessType getProcessType() {
        throw new NotImplementedException("JBPM-1647", "Process Type");
    }

    public Property getProperty(String name) {
        for (Property prop : this.props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public Object getPropertyValue(String name) {
        Property prop = this.getProperty(name);
        return prop != null ? prop.getValue() : null;
    }

    public <T> T getPropertyValue(Class<T> clazz, String name) {
        Property prop = this.getProperty(name);
        return (T)(prop != null ? prop.getValue(clazz) : null);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.props);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Property prop : this.props) {
            names.add(prop.getName());
        }
        return names;
    }

    public void addProperty(Property prop) {
        this.props.add(prop);
    }

    public void addFlowObject(FlowObject flowObject) {
        this.flowObjects.add(flowObject);
    }

    public RuntimeException getRuntimeException() {
        return this.runtimeException;
    }

    public void setRuntimeException(RuntimeException rte) {
        this.runtimeException = rte;
        this.setProcessStatus(Process.ProcessStatus.Aborted);
    }

    public List<FlowObject> getFlowObjects() {
        if (this.status == Process.ProcessStatus.None) {
            return this.flowObjects;
        }
        return Collections.unmodifiableList(this.flowObjects);
    }

    public ObjectName startProcess() {
        return this.startProcessInternal(null);
    }

    public ObjectName startProcess(Attachments att) {
        return this.startProcessInternal(att);
    }

    private ObjectName startProcessInternal(Attachments att) {
        ExecutionManager em = ExecutionManager.locateExecutionManager();
        em.startProcess((Process)this, att);
        return this.getID();
    }

    public void resetProcess() {
        log.debug((Object)("Reset process: " + this));
        for (FlowObject fo : this.flowObjects) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            foImpl.reset();
        }
        this.status = Process.ProcessStatus.Ready;
        this.runtimeException = null;
    }

    public Process.ProcessStatus waitForEnd() {
        return this.waitForEndInternal(0L);
    }

    public Process.ProcessStatus waitForEnd(long timeout) {
        return this.waitForEndInternal(timeout);
    }

    private Process.ProcessStatus waitForEndInternal(long timeout) {
        ExecutionManager em = ExecutionManager.locateExecutionManager();
        return em.waitForEnd((Process)this, timeout);
    }

    public FlowObject getFlowObject(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot find flow object with name: null");
        }
        FlowObject flowObject = null;
        for (FlowObject aux : this.flowObjects) {
            if (!name.equals(aux.getName())) continue;
            flowObject = aux;
            break;
        }
        return flowObject;
    }

    public <T extends FlowObject> List<T> getFlowObjects(Class<T> clazz) {
        ArrayList<FlowObject> retFlowObjects = new ArrayList<FlowObject>();
        for (FlowObject fo : this.flowObjects) {
            if (!clazz.isAssignableFrom(fo.getClass())) continue;
            retFlowObjects.add(fo);
        }
        return retFlowObjects;
    }

    public synchronized Process.ProcessStatus getProcessStatus() {
        return this.status;
    }

    public synchronized void setProcessStatus(Process.ProcessStatus status) {
        this.status = status;
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void addMessage(Message msg) {
        if (this.getMessage(msg.getName()) != null) {
            throw new InvalidProcessException("Duplicate message: " + msg);
        }
        this.messages.add(msg);
    }

    public Message getMessage(String msgName) {
        for (Message msg : this.messages) {
            if (!msg.getName().equals(msgName)) continue;
            return msg;
        }
        return null;
    }

    @Override
    public void create(Process proc) {
        if (this.status != Process.ProcessStatus.None) {
            throw new IllegalStateException("Cannot initialize process in state: " + this.status);
        }
        super.create(this);
        if (this.getName() == null) {
            ProcessManager pm = ProcessManager.locateProcessManager();
            this.name = "AnonymousProcess#" + pm.getProcesses().size();
        }
        if (this.getFlowObjects(StartEvent.class).size() == 0) {
            throw new InvalidProcessException("Process does not have a start event");
        }
        if (this.getFlowObjects(EndEvent.class).size() == 0) {
            throw new InvalidProcessException("Process does not have end events");
        }
        for (FlowObject fo : this.flowObjects) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            foImpl.create(this);
        }
        this.status = Process.ProcessStatus.Ready;
    }

    @Override
    public void register(Process proc) {
        super.register(proc);
        for (FlowObject fo : this.flowObjects) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            foImpl.register(this);
        }
    }

    @Override
    public void unregister(Process proc) {
        for (FlowObject fo : this.flowObjects) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            foImpl.unregister(this);
        }
        super.unregister(proc);
    }

    @Override
    public void destroy(Process proc) {
        for (FlowObject fo : this.flowObjects) {
            FlowObjectImpl foImpl = (FlowObjectImpl)fo;
            foImpl.destroy(this);
        }
        super.destroy(proc);
    }

    protected void initializeMessageRef(Message msgRef) {
        String msgName = msgRef.getName();
        MessageImpl procMsg = (MessageImpl)this.getMessage(msgName);
        if (procMsg == null) {
            throw new IllegalStateException("Cannot obtain process message: " + msgName);
        }
        MessageImpl msgImpl = (MessageImpl)msgRef;
        if (msgImpl.getFromRef() == null && procMsg.getFromRef() != null) {
            msgImpl.setFromRef(procMsg.getFromRef());
        }
        if (msgImpl.getToRef() == null && procMsg.getToRef() != null) {
            msgImpl.setToRef(procMsg.getToRef());
        }
        for (Property prop : procMsg.getProperties()) {
            ((MessageImpl)msgRef).addProperty(prop);
        }
    }

    public String toString() {
        return "Process[" + this.getName() + ",status=" + this.getProcessStatus() + "]";
    }
}

