/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import javax.management.ObjectName;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.model.Entity;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.MessageBuilderFactory;
import org.jboss.bpm.model.Participant;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.ri.model.impl.EntityImpl;
import org.jboss.bpm.ri.model.impl.MessageImpl;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;

class MessageSender {
    private Participant fromRef;
    private Message messageRef;

    public MessageSender(FlowObject fromFlowObject, Message messageRef) {
        ObjectName procID = fromFlowObject.getProcess().getID();
        this.fromRef = new EntityImpl(procID);
        this.messageRef = messageRef;
        if (messageRef == null) {
            throw new IllegalArgumentException("MessageRef cannot be null");
        }
        if (this.fromRef == null) {
            throw new IllegalArgumentException("FromRef cannot be null");
        }
    }

    public void sendMessage(Token token) {
        ExecutionContext exContext = token.getExecutionContext();
        MessageBuilderFactory factory = MessageBuilderFactory.newInstance();
        MessageBuilder msgBuilder = factory.newMessageBuilder();
        Participant toRef = this.messageRef.getToRef();
        if (toRef == null || toRef.getEntityRef() == null) {
            throw new IllegalStateException("Cannot obtain target participant");
        }
        Entity entityRef = toRef.getEntityRef();
        ObjectName targetID = entityRef.getName();
        msgBuilder.newMessage(this.messageRef.getName());
        msgBuilder.addToRef(targetID);
        for (Property auxProp : this.messageRef.getProperties()) {
            String key = auxProp.getName();
            Object value = exContext.getAttachment(key);
            if (value == null) {
                throw new IllegalStateException("Cannot obtain property: " + key);
            }
            msgBuilder.addProperty(key, value);
        }
        MessageImpl msg = (MessageImpl)msgBuilder.getMessage();
        msg.setFromRef(this.fromRef);
        MessageManager mm = MessageManager.locateMessageManager();
        mm.sendMessage((Message)msg);
    }
}

