/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.MutablePropertySupport;
import org.jboss.bpm.model.Participant;
import org.jboss.bpm.model.Property;
import org.jboss.bpm.ri.model.impl.SupportingElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends SupportingElementImpl
implements Message,
MutablePropertySupport {
    private String name;
    private Participant fromRef;
    private Participant toRef;
    private List<Property> props = new ArrayList<Property>();

    public MessageImpl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Message name cannot be null");
        }
        this.name = name;
    }

    public MessageImpl(String name, Participant targetID, Participant sourceID) {
        this(name);
        this.toRef = targetID;
        this.fromRef = sourceID;
    }

    public String getName() {
        return this.name;
    }

    public Property getProperty(String name) {
        for (Property prop : this.props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public Object getPropertyValue(String name) {
        Property prop = this.getProperty(name);
        return prop != null ? prop.getValue() : null;
    }

    public <T> T getPropertyValue(Class<T> clazz, String name) {
        Property prop = this.getProperty(name);
        return (T)(prop != null ? prop.getValue(clazz) : null);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.props);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Property prop : this.props) {
            names.add(prop.getName());
        }
        return names;
    }

    public void addProperty(Property prop) {
        this.props.add(prop);
    }

    public Participant getFromRef() {
        return this.fromRef;
    }

    public void setFromRef(Participant fromRef) {
        this.fromRef = fromRef;
    }

    public Participant getToRef() {
        return this.toRef;
    }

    public void setToRef(Participant toRef) {
        this.toRef = toRef;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Message[name=" + this.name + ",props=");
        str.append(this.getPropertyNames());
        str.append("]");
        return str.toString();
    }
}

