/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.model.impl;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.EndEvent;
import org.jboss.bpm.model.Event;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.EventDetail;
import org.jboss.bpm.model.IntermediateEvent;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.ri.model.impl.EndEventImpl;
import org.jboss.bpm.ri.model.impl.EventImpl;
import org.jboss.bpm.ri.model.impl.FlowObjectImpl;
import org.jboss.bpm.ri.model.impl.IntermediateEventImpl;
import org.jboss.bpm.ri.model.impl.MessageEventDetailImpl;
import org.jboss.bpm.ri.model.impl.MessageImpl;
import org.jboss.bpm.ri.model.impl.ProcessBuilderImpl;
import org.jboss.bpm.ri.model.impl.ProcessImpl;
import org.jboss.bpm.ri.model.impl.SignalEventDetailImpl;
import org.jboss.bpm.ri.model.impl.StartEventImpl;

public class EventBuilderImpl
extends ProcessBuilderImpl
implements EventBuilder {
    private EventDetail eventDetail;

    public EventBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject) {
        super(proc, flowObject);
    }

    public EventBuilder addEventDetail(EventDetail.EventDetailType detailType) {
        if (detailType == EventDetail.EventDetailType.Message) {
            this.eventDetail = new MessageEventDetailImpl();
            this.addEventDetail(this.getEvent(), this.eventDetail);
        } else {
            if (detailType == EventDetail.EventDetailType.Timer) {
                throw new NotImplementedException("JBPM-1663", "EventDetail Timer");
            }
            if (detailType == EventDetail.EventDetailType.Error) {
                throw new NotImplementedException("JBPM-1664", "EventDetail Error");
            }
            if (detailType == EventDetail.EventDetailType.Cancel) {
                throw new NotImplementedException("JBPM-1665", "EventDetail Cancel");
            }
            if (detailType == EventDetail.EventDetailType.Compensation) {
                throw new NotImplementedException("JBPM-1666", "EventDetail Compensation");
            }
            if (detailType == EventDetail.EventDetailType.Conditional) {
                throw new NotImplementedException("JBPM-1667", "EventDetail Conditional");
            }
            if (detailType == EventDetail.EventDetailType.Link) {
                throw new NotImplementedException("JBPM-1668", "EventDetail Link");
            }
            if (detailType == EventDetail.EventDetailType.Signal) {
                this.eventDetail = new SignalEventDetailImpl();
                this.addEventDetail(this.getEvent(), this.eventDetail);
            }
        }
        return this;
    }

    public EventBuilder addSignalRef(Signal.SignalType signalType, String message) {
        if (!(this.eventDetail instanceof SignalEventDetailImpl)) {
            throw new IllegalStateException("Cannot add signal to: " + this.eventDetail);
        }
        SignalEventDetailImpl signalEventDetail = (SignalEventDetailImpl)this.eventDetail;
        signalEventDetail.setSignalRef(new Signal(this.flowObject.getID(), signalType, message));
        return this;
    }

    public EventBuilder addMessageRef(String msgName) {
        MessageImpl message = new MessageImpl(msgName);
        if (!(this.eventDetail instanceof MessageEventDetailImpl)) {
            throw new IllegalStateException("Cannot add message to: " + this.eventDetail);
        }
        MessageEventDetailImpl msgEventDetail = (MessageEventDetailImpl)this.eventDetail;
        msgEventDetail.setMessageRef(message);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addEventDetail(EventImpl event, EventDetail trigger) {
        EventDetail.EventDetailType detailType = trigger.getEventDetailType();
        if (event instanceof StartEvent) {
            StartEventImpl start = (StartEventImpl)event;
            if (start.getTrigger().size() > 0) {
                throw new NotImplementedException("JBPM-1660", "StartEvent Multiple Trigger");
            }
            if (detailType == EventDetail.EventDetailType.Message) {
                throw new NotImplementedException("JBPM-1657", "StartEvent Message Trigger");
            }
            if (detailType == EventDetail.EventDetailType.Timer) {
                throw new NotImplementedException("JBPM-1658", "StartEvent Timer Trigger");
            }
            if (detailType == EventDetail.EventDetailType.Conditional) {
                throw new NotImplementedException("JBPM-1659", "StartEvent Conditional Trigger");
            }
            if (detailType != EventDetail.EventDetailType.Signal) throw new IllegalStateException("Unsupported start event trigger type: " + detailType);
            start.addTrigger(this.eventDetail);
            return;
        } else {
            if (event instanceof IntermediateEvent) {
                IntermediateEventImpl intermediate = (IntermediateEventImpl)event;
                if (intermediate.getTrigger().size() > 0) {
                    throw new NotImplementedException("JBPM-1682", "IntermediateEvent Multiple Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Message) {
                    throw new NotImplementedException("JBPM-1669", "IntermediateEvent Message Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Timer) {
                    throw new NotImplementedException("JBPM-1670", "IntermediateEvent Timer Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Error) {
                    throw new NotImplementedException("JBPM-1671", "IntermediateEvent Error Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Cancel) {
                    throw new NotImplementedException("JBPM-1672", "IntermediateEvent Cancel Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Compensation) {
                    throw new NotImplementedException("JBPM-1673", "IntermediateEvent Compensation Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Conditional) {
                    throw new NotImplementedException("JBPM-1674", "IntermediateEvent Conditional Trigger");
                }
                if (detailType == EventDetail.EventDetailType.Link) {
                    throw new NotImplementedException("JBPM-1675", "IntermediateEvent Link Trigger");
                }
                if (detailType != EventDetail.EventDetailType.Signal) throw new IllegalStateException("Unsupported intermediate event trigger type: " + detailType);
                throw new NotImplementedException("JBPM-1650", "IntermediateEvent Signal Trigger");
            }
            if (!(event instanceof EndEvent)) return;
            EndEventImpl end = (EndEventImpl)event;
            if (end.getResult().size() > 0) {
                throw new NotImplementedException("JBPM-1683", "EndEvent Multiple Result");
            }
            if (detailType == EventDetail.EventDetailType.Message) {
                end.addResult(this.eventDetail);
                return;
            } else {
                if (detailType == EventDetail.EventDetailType.Error) {
                    throw new NotImplementedException("JBPM-1677", "EndEvent Error Result");
                }
                if (detailType == EventDetail.EventDetailType.Cancel) {
                    throw new NotImplementedException("JBPM-1678", "EndEvent Cancel Result");
                }
                if (detailType == EventDetail.EventDetailType.Compensation) {
                    throw new NotImplementedException("JBPM-1679", "EndEvent Compensation Result");
                }
                if (detailType == EventDetail.EventDetailType.Signal) {
                    throw new NotImplementedException("JBPM-1651", "EndEvent Signal Result");
                }
                if (detailType != EventDetail.EventDetailType.Terminate) throw new IllegalStateException("Unsupported end event trigger type: " + detailType);
                throw new NotImplementedException("JBPM-1680", "EndEvent Terminate Result");
            }
        }
    }

    private EventImpl getEvent() {
        if (!(this.flowObject instanceof Event)) {
            throw new IllegalStateException("Last added flow object is not an Event: " + this.flowObject);
        }
        return (EventImpl)this.flowObject;
    }
}

