/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.client;

import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.client.MessageListener;
import org.jboss.bpm.client.MessageManager;
import org.jboss.bpm.client.ProcessManager;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.ri.model.impl.ProcessImpl;

public class MessageManagerImpl
extends MessageManager {
    private static final Log log = LogFactory.getLog(MessageManagerImpl.class);

    public void sendMessage(ObjectName procID, String targetName, Message msg) {
        ProcessManager pm = ProcessManager.locateProcessManager();
        Process proc = pm.getProcessByID(procID);
        if (proc == null) {
            throw new IllegalStateException("Cannot obtain registered process: " + procID);
        }
        ProcessImpl procImpl = (ProcessImpl)proc;
        FlowObject target = procImpl.getFlowObject(targetName);
        if (target == null) {
            throw new IllegalArgumentException("Cannot find message target: " + targetName);
        }
        if (!(target instanceof MessageListener)) {
            throw new IllegalArgumentException("Message target is not a valid message receiver: " + targetName);
        }
        log.debug((Object)("sendMessage to " + target + " => " + msg));
        MessageListener msgListener = (MessageListener)target;
        msgListener.catchMessage(msg);
    }
}

