/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import org.jboss.bpm.model.Message;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.model.Message.Implementation;

//$Id: UserTask.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

/**
 * A User Task is a typical “workflow” task where a human performer performs the Task with the assistance of a software
 * application and is scheduled through a task list manager of some sort.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface UserTask extends Task
{
  /**
   * A Message for the InMessageRef attribute MUST be entered. This indicates
   * that the Message will be received at the start of the Task, after the
   * availability of any defined InputSets. One or more corresponding incoming
   * Message Flows MAY be shown on the diagram. However, the display of the
   * Message Flow is not required. The Message is applied to all incoming
   * Message Flow, but can arrive for only one of the incoming Message Flow
   * for a single instance of the 
   */
  Message getInMessageRef();
  
  /**
   * A Message for the OutMessageRef attribute MUST be entered. The sending
   * of this message marks the completion of the Task, which may cause the
   * production of an OutputSet. One or more corresponding outgoing Message
   * Flow MAY be shown on the diagram. However, the display of the Message
   * Flow is not required. The Message is applied to all outgoing Message Flow
   * and the Message will be sent down all outgoing Message Flow at the
   * completion of a single instance of the 
   */
  Message getOutMessageRef();

  /**
   * This attribute specifies the technology that will be used to send or receive the message. A Web service is the default technology.
   */
  Implementation getImplementation();
}