/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import org.jboss.bpm.model.Task;

//$Id: ScriptTask.java 1929 2008-08-19 10:48:17Z thomas.diesler@jboss.com $

/**
 * A Script Task is executed by a business process engine. The modeler or implementer defines a script in a language that
 * the engine can interpret. When the Task is ready to start, the engine will execute the script. When the script is completed,
 * the Task will also be completed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ScriptTask extends Task
{
  /**
   * The modeler MAY include a script that can be run when the Task is performed. If
   * a script is not included, then the Task will act equivalent to a TaskType of None.
   */
  String getScript();
}