/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import org.jboss.bpm.model.ExclusiveGateway;
import org.jboss.bpm.model.Gate;


//$Id: ExclusiveGatewayDataBased.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

/**
 * The Data-Based Exclusive Gateways are the most commonly used type of Gateways. The set of Gates for Data-Based
 * Exclusive Decisions is based on the boolean expression contained in the ConditionExpression attribute of the outgoing
 * Sequence Flow of the  These expressions use the values of process data to determine which path should be taken
 * (hence the name Data-Based).
 * 
 * The conditions for the alternative Gates should be evaluated in a specific order. The first one that evaluates as TRUE will
 * determine the Sequence Flow that will be taken. Since the behavior of this Gateway is exclusive, any other conditions that
 * may actually be TRUE will be ignored--only one Gate can be chosen. One of the Gates may be “default” (or otherwise),
 * and is the last Gate considered. This means that if none of the other Gates are chosen, then the default Gate will be
 * chosen—along with its associated Sequence Flow.
 * 
 * The default Gate is not mandatory for a  This means that if it is not used, then it is up to the modeler to insure
 * that at least one Gate be valid at runtime. BPMN does not specify what will happen if there are no valid Gates. However,
 * BPMN does specify that there MUST NOT be implicit flow and that all Normal Flow of a Process must be expressed
 * through Sequence Flow. This would mean that a Process Model that has a Gateway that potentially does not have a valid
 * Gate at runtime is an invalid model.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ExclusiveGatewayDataBased extends ExclusiveGateway
{
  /**
   * A Default Gate MAY be specified
   */
  Gate getDefaultGate();

}