/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.spec;

import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.SupportingElement;

//$Id: Condition.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

/**
 * A Condition, which is used in the definition of attributes for Start Event and
 * Intermediate Event
 *  
 * @author thomas.diesler@jboss.com
 * @since 21-Jul-2008
 */
public interface Condition extends SupportingElement
{
  /**
   * Name is an optional attribute that is text description of the Condition. If a Name is
   * not entered, then a ConditionExpression MUST be entered
   */
  String getName();
  
  /**
   * A ConditionExpression MAY be entered. In some cases the Condition itself will be
   * stored and maintained in a separate application (e.g., a Rules Engine). If a ConditionExpression 
   * is not entered, then a Name MUST be entered
   */
  Expression getConditionExpression();

}
