/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

import javax.management.ObjectName;

import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Constants;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.Task;
import org.jboss.bpm.runtime.SignalHandler;
import org.jboss.bpm.runtime.Token;
import org.jboss.util.id.UID;

//$Id: TaskImpl.java 1982 2008-08-22 10:09:27Z thomas.diesler@jboss.com $

/**
 * A Task is an Atomic Activity that is included within a Process.
 * 
 * A Task is used when the work in the Process is not broken down to a finer level of Process Model detail. Generally,
 * an end-user and/or an application are used to perform the Task when it is executed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public abstract class TaskImpl extends ActivityImpl implements Task
{
  public TaskImpl(String name)
  {
    super(name);
  }

  public ActivityType getActivityType()
  {
    return ActivityType.Task;
  }

  public abstract TaskType getTaskType();

  @Override
  public ObjectName getID()
  {
    if (id == null)
    {
      StringBuilder str = new StringBuilder(Constants.ID_DOMAIN + ":");
      str.append("type=" + getTaskType() + "Task,name=" + getName() + ",id=" + new UID());
      id = ObjectNameFactory.create(str.toString());
    }
    return id;
  }
  
  public SignalHandler getSignalHandler()
  {
    SignalHandler handler = super.getSignalHandler();
    if (handler == null)
    {
      handler = new SignalHandler()
      {
        SignalManager signalManager = SignalManager.locateSignalManager();

        public void throwEnterSignal(Token token)
        {
          Signal signal = new Signal(getID(), Signal.SignalType.SYSTEM_TASK_ENTER);
          signalManager.throwSignal(signal);
        }

        public void throwExitSignal(Token token)
        {
          Signal signal = new Signal(getID(), Signal.SignalType.SYSTEM_TASK_EXIT);
          signalManager.throwSignal(signal);
        }
      };
    }
    return handler;
  }

  public String toString()
  {
    return "Task[" + getTaskType() + "," + getName() + "]";
  }
}