/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: TaskBuilderImpl.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Task;
import org.jboss.bpm.model.TaskBuilder;

/**
 * The TaskBuilder can be used to dynamically build {@link Task}.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class TaskBuilderImpl extends ActivityBuilderImpl implements TaskBuilder
{
  public TaskBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject)
  {
    super(proc, flowObject);
  }

  public TaskBuilder addMessageRef(String msgName)
  {
    MessageImpl message = new MessageImpl(msgName);
    if (flowObject instanceof ReceiveTaskImpl)
    {
      ReceiveTaskImpl receiveTask = (ReceiveTaskImpl)flowObject;
      receiveTask.setMessageRef(message);
    }
    else if (flowObject instanceof SendTaskImpl)
    {
      SendTaskImpl sendTask = (SendTaskImpl)flowObject;
      sendTask.setMessageRef(message);
    }
    else
    {
      throw new IllegalStateException("Cannot add message to: " + flowObject);
    }
    return this;
  }

  public TaskBuilder addExecutionHandler(Class<?> clazz)
  {
    super.addExecutionHandler(clazz);
    return this;
  }
}