/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: SequenceFlowImpl.java 1946 2008-08-20 22:09:12Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.SequenceFlow;

/**
 * A Sequence Flow is a solid graphical line that is used to show the order that Activities will be performed in a Process. 
 * Each Flow has only one source and only one target.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class SequenceFlowImpl extends FlowImpl implements SequenceFlow
{
  private ConditionType conditionType = ConditionType.None;
  private Expression conditionExpression;
  
  public SequenceFlowImpl(String targetName)
  {
    super(targetName);
  }

  public SequenceFlowImpl(String targetName, ConditionType type, Expression expr)
  {
    super(targetName);
    this.conditionType = type;
    this.conditionExpression = expr;
  }

  public ConditionType getConditionType()
  {
    return conditionType;
  }
  
  public Expression getConditionExpression()
  {
    return conditionExpression;
  }
  
  public String toString()
  {
    FlowObject sourceRef = getSourceRef();
    FlowObject targetRef = getTargetRef();
    
    String srcName = null;
    if (sourceRef != null)
      srcName = (sourceRef.getName() != null ? sourceRef.getName() : sourceRef.getID().getCanonicalName());
    
    String tarName = null;
    if (targetRef != null)
      tarName = (targetRef.getName() != null ? targetRef.getName() : targetRef.getID().getCanonicalName());
    
    return "SequenceFlow[" + srcName + "->" + tarName + "]";
  }
}