/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: RuntimeProcessImpl.java 1946 2008-08-20 22:09:12Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Process;
import org.jboss.bpm.ri.runtime.RuntimeProcess;
import org.jboss.bpm.runtime.TokenExecutor;

/**
 * A RuntimeProcess add runtime behaviour to the {@link Process}
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class RuntimeProcessImpl implements RuntimeProcess
{
  private Process proc;
  private TokenExecutor tokenExecutor;

  public RuntimeProcessImpl(Process proc)
  {
    this.proc = proc;
    this.tokenExecutor = new TokenExecutorImpl(this);
  }

  public Process getProcess()
  {
    return proc;
  }

  public TokenExecutor getTokenExecutor()
  {
    return tokenExecutor;
  }
  
  public String toString()
  {
    return "RuntimeProcess[" + proc.getName() + ",status=" + proc.getProcessStatus() + "]";
  }
}