/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: PropertyImpl.java 1936 2008-08-19 23:22:38Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Expression;
import org.jboss.bpm.model.Property;

/**
 * A Property, which is used in the definition of attributes for a Process and common activity attributes
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public class PropertyImpl extends SupportingElementImpl implements Property
{
  private String name;
  private Expression expression;
  private boolean isCorrelation;

  public PropertyImpl(String name, Expression expression)
  {
    this.expression = expression;
    this.name = name;
  }

  public PropertyImpl(String name, Expression expression, boolean isCorrelation)
  {
    this.name = name;
    this.expression = expression;
    this.isCorrelation = isCorrelation;
  }

  public String getName()
  {
    return name;
  }

  public void setName(String name)
  {
    this.name = name;
  }

  public PropertyType getPropertyType()
  {
    return PropertyType.String;
  }

  public Expression getExpression()
  {
    return expression;
  }

  public void setExpression(Expression expression)
  {
    this.expression = expression;
  }

  public boolean isCorrelation()
  {
    return isCorrelation;
  }

  public void setCorrelation(boolean isCorrelation)
  {
    this.isCorrelation = isCorrelation;
  }

  public Object getValue()
  {
    return (expression != null ? expression.getExpressionValue() : null);
  }

  @SuppressWarnings("unchecked")
  public <T> T getValue(Class<T> T)
  {
    return (T)(expression != null ? expression.getExpressionValue() : null);
  }
}
