/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: HandlerImpl.java 1928 2008-08-19 10:45:22Z thomas.diesler@jboss.com $

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.runtime.Handler;

/**
 * Base implementation of all handlers
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
@SuppressWarnings("serial")
public abstract class HandlerImpl implements Handler
{
  private String className;
  private String beanRef;
  
  public String getClassName()
  {
    return className;
  }

  public void setClassName(String className)
  {
    this.className = className;
  }

  public String getBeanRef()
  {
    return beanRef;
  }

  public void setBeanRef(String beanRef)
  {
    this.beanRef = beanRef;
  }

  @SuppressWarnings("unchecked")
  protected <T> T newInstance(Class<T> clazz)
  {
    try
    {
      if (className != null)
      {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        return (T)ctxLoader.loadClass(className).newInstance();
      }
      else if (beanRef != null)
      {
        throw new NotImplementedException("JBPM-1642", "Handler BeanRef");
      }
      else
      {
        throw new IllegalStateException("There is no 'class' nor 'bean' attribute set for this handler");
      }
    }
    catch (Exception ex)
    {
      throw new IllegalStateException("Cannot instanciate the handler", ex);
    }
  }
}