/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.ri.model.impl;

//$Id: GatewayBuilderImpl.java 1930 2008-08-19 11:04:43Z thomas.diesler@jboss.com $

import org.jboss.bpm.model.Gate;
import org.jboss.bpm.model.Gateway;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.Expression.ExpressionLanguage;
import org.jboss.bpm.model.SequenceFlow.ConditionType;

/**
 * The GatewayBuilder can be used to build a {@link Gateway} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public class GatewayBuilderImpl extends ProcessBuilderImpl implements GatewayBuilder
{
  private Gate gate;

  public GatewayBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject)
  {
    super(proc, flowObject);
  }

  public GatewayBuilder addGate(String targetName)
  {
    gate = new GateImpl(targetName);
    getGateway().addGate(gate);
    return this;
  }

  public GatewayBuilder addConditionalGate(String targetName, ExpressionLanguage lang, String body)
  {
    gate = new GateImpl(targetName, ConditionType.Expression, new ExpressionImpl(lang, body));
    getGateway().addGate(gate);
    return this;
  }

  public GatewayBuilder addDefaultGate(String targetName)
  {
    gate = new GateImpl(targetName, ConditionType.Default, null);
    getGateway().addGate(gate);
    return this;
  }
  
  private GatewayImpl getGateway()
  {
    if (flowObject instanceof Gateway == false)
      throw new IllegalStateException("Last added flow object is not a Gateway: " + flowObject);
    return (GatewayImpl)flowObject;
  }
}